<?php
/**
 * Search Form
 *
 * @decription Contains the search for the search widget.
 * @author EZSolution Corp.
 * @since EZTheme 2.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include
?>
<form role="search" method="get" class="search-form" id="search-form" action="<?php echo home_url( '/' ); ?>">
	<div class="form-group">
        <label class="control-label screen-reader-text" for="s"><?php echo _x( 'Search for:', 'label' ); ?></label>
        <div class="inner-addon right-addon">
            <input type="search" class="form-control search-field" placeholder="<?php echo esc_attr_x( 'Search…', 'placeholder' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label' ); ?>" />
        	<input type="submit" class="search-submit hidden" value="<?php echo esc_attr_x( 'Search', 'submit button' ); ?>" />
            <i class="glyphicon glyphicon-search"></i>
        </div>
    </div>
</form>