<?php
/**
 * Header
 *
 * @decription Contains the Doctype, 
 * @author Stephen Sabatini
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

// Detect Internet Explorer, Windows Phone, and Edge
$ie = preg_match( '/(MSIE|Windows\sPhone|Edge)/i', $_SERVER['USER_AGENT'] );

// Define Theme Directory
$template_directory_uri = get_template_directory_uri();

// Define theme mods from the theme's customise options.
$logo  = get_theme_mod( 'eztheme_logo' );
$phone = get_theme_mod( 'eztheme_phone' );
$email = get_theme_mod( 'eztheme_email' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
		<?php if ( $ie ) { ?><meta http-equiv="X-UA-Compatible" content="IE=Edge" /><?php } ?>
        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <?php wp_head();
		if ( $ie ) { ?>
		<!--[if lt IE 9]><?php
		  ?><script src="<?php echo $template_directory_uri; ?>/js/html5shiv.min.js"></script><?php
		  ?><script src="<?php echo $template_directory_uri; ?>/js/respond.min.js"></script><?php
		?><![endif]-->
		<?php } ?>
    </head>
    <body <?php body_class(); ?>>
        <div class="site-wrapper">
            <header class="site-header">
                <nav class="navbar navbar-default">
                    <div class="section-top">
                        <div class="container">
                            <div class="navbar-header col-sm-4 col-md-3 col-lg-4">
                                <a class="navbar-brand" href="<?php echo home_url(); ?>" rel="home">
                                    <?php if ( isset( $logo ) && $logo !== '' ) { ?>
                                    <img class="site-logo" src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                                    <?php } else { ?>
                                    <div class="site-title"><?php bloginfo( 'name' ); ?></div>
                                    <?php } ?>
                                </a>
                            </div><!-- /.navbar-header -->
                            <?php if ( $phone !== false || $email !== false ) { ?>
                            <div class="site-meta col-sm-8 col-md-9 col-lg-8">
								<?php if ( $phone !== false ) { ?>
                                <div class="site-tel"><a href="tel:<?php echo preg_replace( "/[^0-9]/", "", $phone ); ?>" target="_blank"><?php echo $phone; ?></a></div>
                                <?php
                                } if ( $email !== false ) { ?>
                                <div class="site-email"><a href="mailto:<?php echo $email; ?>" target="_blank"><?php echo $email; ?></a></div>
                                <?php } ?>
                            </div>
                            <?php } ?>
                            <div class="clearfix"></div>
                        </div><!-- /.container -->
                    </div><!-- /.section-top -->
                    <div class="site-navigation">
                        <div class="container">
                            <?php
                                wp_nav_menu( array(
                                    'menu'              => 'menu-header',
                                    'theme_location'    => 'menu-header',
                                    'depth'             => 3,
                                    'container'         => 'div',
                                    'container_id'      => 'menu-header'
                                ) );
                            ?>
                            <script>
                            jQuery(function(){
                                jQuery('.site-navigation .menu > ul').slicknav();
                            });
                            </script>
                        </div><!-- /.container -->
                    </div><!-- /.site-navigation -->
                </nav><!-- /.navbar.navbar-default -->
            </header><!-- /.site-header -->
