<?php
/**
 * Function Definitions
 *
 * @decription Contains the functions for the WordPress theme.
 * @author Stephen Sabatini
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include


// Sets up theme defaults and registers support for various WordPress features.
function theme_setup() {

	// Make theme available for translation.
	//load_theme_textdomain( 'eztheme', get_template_directory() . '/languages' );

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// Enable support for Post Thumbnails on posts and pages.
	add_theme_support( 'post-thumbnails' );
	
	// Set the thumbnail sizes for the posts.
	//set_post_thumbnail_size( 825, 510, true );

	// Switch default core markup for search form, comment form, and comments to output valid HTML5.
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
	) );

	// Declare support for WooCommerce
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'theme_setup' );


// Register Custom Menus that are used in the theme.
function theme_menus_init() {
	register_nav_menus( array(
		'menu-header' => __( 'Main Menu', 'eztheme' )
	) );
}
add_action( 'init', 'theme_menus_init' );


// Register Custom Sidebars/Widgets that are used in the theme.
function theme_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Blog Sidebar', 'eztheme' ),
		'id' => 'sidebar-blog',
		'description' => __( 'Widgets in this area will be shown on the blog index sidebar.', 'eztheme' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widgettitle">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'theme_widgets_init' );


// This function include the Bootstrap CSS and JavaScript.
function theme_enqueue_styles() {
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' );
	wp_enqueue_style( 'slicknav', get_template_directory_uri() . '/css/slicknav.css', array( 'bootstrap' ) );
	wp_enqueue_script( 'slicknav-script', get_template_directory_uri() . '/js/jquery.slicknav.min.js', array( 'jquery' ) );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js',  array( 'jquery' ) );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );


// Add our items to the theme customize page.
function theme_customize_register( $wp_customize ) {


	// Add a section to the theme customize page for us to upload our logo.
	$wp_customize->add_section( 'eztheme_header_section' , array(
		'title' => __( 'Header', 'eztheme' ),
		'priority' => 30,
		'description' => ''
	) );
	$wp_customize->add_setting( 'eztheme_logo' ); // Register our new logo setting
	$wp_customize->add_setting( 'eztheme_phone' ); // Register our new phone setting
	$wp_customize->add_setting( 'eztheme_email' ); // Register our new email setting


	// Assign a control to the logo section for uploading our image.
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'eztheme_logo', array(
		'label' => __( 'Logo', 'eztheme' ),
		'section' => 'eztheme_header_section',
		'settings' => 'eztheme_logo'
	) ) );


	// Assign a control to the phone section for uploading our image.
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'eztheme_phone', array(
		'label'    => __( 'Phone Number', 'eztheme' ),
		'section'  => 'eztheme_header_section',
		'settings' => 'eztheme_phone',
		'type'     => 'text'
	) ) );


	// Assign a control to the email section for uploading our image.
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'eztheme_phoneemail', array(
		'label'    => __( 'Email Address', 'eztheme' ),
		'section'  => 'eztheme_header_section',
		'settings' => 'eztheme_email',
		'type'     => 'text'
	) ) );


	// Add a section to the theme customize page for the footer.
	$wp_customize->add_section( 'eztheme_footer_section' , array(
		'title' => __( 'Footer', 'eztheme' ),
		'priority' => 30,
		'description' => ''
	) );
	$wp_customize->add_setting( 'eztheme_copyright' ); // Register our new phone setting


	// Assign a control to the phone section for uploading our image.
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'eztheme_copyright', array(
		'label'    => __( 'Copyright', 'eztheme' ),
		'section'  => 'eztheme_footer_section',
		'settings' => 'eztheme_copyright',
		'type'     => 'textarea'
	) ) );
}
add_action( 'customize_register', 'theme_customize_register' );


// Check if WooCommerce is active
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

	// Gets the Tab information and puts it in the Summary area along the top right.
	function woocommerce_template_product_description() {
		woocommerce_get_template( 'single-product/tabs/description.php' );
		woocommerce_get_template( 'single-product/tabs/additional-information.php' );
	}
	add_action( 'woocommerce_single_product_summary', 'woocommerce_template_product_description', 5 );


	// Removes the Short Description from the admin section to avoid confusion.
	function remove_short_description() {
		 remove_meta_box( 'postexcerpt', 'product', 'normal');
	}
	add_action('add_meta_boxes', 'remove_short_description', 999);


	// Removes the Short Description from the Summary area along the top right because it's replaced with the long one.
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
}
remove_action('wp_head', 'wp_generator');
