<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$top_box = get_field( 'top_box' );$texas_auto_accidents_section_1 = get_field( 'texas_auto_accidents_section_1' );
$texas_auto_accidents_section_2 = get_field( 'texas_auto_accidents_section_2' );
$texas_auto_accidents_side_effects = get_field( 'texas_auto_accidents_side_effects' );
$texas_auto_accidents_side_effects_list_1 = get_field( 'texas_auto_accidents_side_effects_list_1' );
$texas_auto_accidents_side_effects_list_2 = get_field( 'texas_auto_accidents_side_effects_list_2' );
$texas_auto_accidents_lawsuits = get_field( 'texas_auto_accidents_lawsuits' );
$texas_auto_accidents_case_review = get_field( 'texas_auto_accidents_case_review' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
	yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php if ( $top_box ) { ?><div class="box-top"><div class="col-sm-9"><h2><?php echo $top_box; ?></h2></div><div class="col-sm-3"><a class="btn btn-block btn-lg btn-orange" href="/contact/">FREE CASE REVIEW</a></div><div class="clearfix"></div></div><?php } ?>
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
                <div class="row">
                    <div class="col-sm-7"><?php echo $texas_auto_accidents_section_1; ?></div>
                    <div class="col-sm-5">
                    	<div class="video-container paddtop">
                        	<iframe width="400" height="225" src="https://www.youtube.com/embed/oI31zN2HrbU?rel=0" frameborder="0" allowfullscreen></iframe></div>
                		</div>
                </div>
                <div class="clearfix"></div>
                <?php echo $texas_auto_accidents_section_2; ?>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    <section class="photo-banner">
    	<div class="container">
        	<?php echo $texas_auto_accidents_side_effects; ?>
        	<div class="col-sm-6"><?php echo $texas_auto_accidents_side_effects_list_1; ?></div>
        	<div class="col-sm-6"><?php echo $texas_auto_accidents_side_effects_list_2; ?></div>
            <?php echo $texas_auto_accidents_lawsuits; ?>
        	<div class="clearfix"></div>
        </div>
    </section>
    <!--- free case review callout --->  
   <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $texas_auto_accidents_case_review; ?>
            <a class="btn btn-ghost-light" href="/contact/">Review My Case</a>
        </div>
    </section> 

<?php get_footer(); ?>