<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$top_box = get_field( 'top_box' );$taxotere_section_1 = get_field( 'taxotere_section_1' );
$taxotere_section_2 = get_field( 'taxotere_section_2' );
$taxotere_lawsuits = get_field( 'taxotere_lawsuits' );
$taxotere_what_you_can_do_now = get_field( 'taxotere_what_you_can_do_now' );
$taxotere_case_review = get_field( 'taxotere_case_review' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>
	
    <main class="site-content">
        <div class="container">
        	<?php if ( $top_box ) { ?><div class="box-top"><div class="col-sm-9"><h2><?php echo $top_box; ?></h2></div><div class="col-sm-3"><a class="btn btn-block btn-lg btn-orange" href="/contact/">FREE CASE REVIEW</a></div><div class="clearfix"></div></div><?php } ?>
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
                <div class="row">
                <div class="col-sm-8">
				<?php echo $taxotere_section_1; ?>
				</div>
                
                <div class="col-sm-4">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/taxotere.png" alt="" />
                </div>
                </div>
                <div class="clearfix"></div>
                
                <?php echo $taxotere_section_2; ?>
                

            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    
    <section class="photo-banner">
    	<div class="container">
        <?php echo $taxotere_what_you_can_do_now; ?>
        <div class="clearfix"></div>
        </div>
    </section>
    
    <!---- text boxes --->
    
    <section>
    	<div class="container">
        
        	<div class="box">
            
            <?php echo $taxotere_lawsuits; ?>
            
            </div>
        
        <div class="clearfix"></div>
        
        
        </div>
    </section>  
    
    <!--- free case review callout --->  
    
   <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $taxotere_case_review; ?>
            <a class="btn btn-ghost-light" href="/contact/">Review My Case</a>
        </div>
    </section> 
        
        
    
<?php get_footer(); ?>