<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$top_box = get_field( 'top_box' );$ivc_section_1 = get_field( 'ovarian_section_1' );
$ivc_section_2 = get_field( 'ovarian_section_2' );
$ivc_section_3 = get_field( 'ovarian_section_3' );
$ivc_section_4 = get_field( 'ovarian_section_4' );
$ivc_case_review = get_field( 'test' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
                <div class="row">
                    <div class="col-sm-8">
						<?php while ( have_posts() ) : the_post(); ?>
                        <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <div class="page-content">
                                <?php
                                the_content();
                                wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                                ?>
                            </div><!-- /.page-content -->
                        </article><!-- /#page-<?php the_ID(); ?> -->
                        <?php endwhile; ?>
                	</div>
                    <div class="col-sm-4"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/ivc1.jpg" alt="" /></div>
                </div>
                <?php echo $ivc_section_1; ?> 
                <?php echo $ivc_section_2; ?>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
            <br><br>
                
            <div class="col-sm-6">    
            <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/ivc3.jpg" alt="" />
            <?php echo $ivc_section_3; ?>
            </div>
            
                
            <div class="col-sm-6">   
            <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/hips2.jpg" alt="" /> 
            <?php echo $ivc_section_4; ?>
            </div>
            

            <div class="clearfix"></div>
            
            
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    
    
      <!--- free case review callout --->  
    
   <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $ivc_case_review; ?>
            <a class="btn btn-ghost-light" href="blank">Get a FREE Case Review</a>
        </div>
    </section>          
        

<?php get_footer(); ?>