<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$top_box = get_field( 'top_box' );$ssd_section_1 = get_field( 'ssd_section_1' );
$ssd_section_2 = get_field( 'ssd_section_2' );
$ssd_section_4 = get_field( 'ssd_section_4' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
            	<div class="row">
                	<div class="col-sm-8">
						<?php while ( have_posts() ) : the_post(); ?>
                        <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <div class="page-content">
                                <?php
                                the_content();
                                wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                                ?>
                            </div><!-- /.page-content -->
                        </article><!-- /#page-<?php the_ID(); ?> -->
                        <?php endwhile; ?>
                    </div>
                    <div class="col-sm-4"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/social-security-disability.jpg" alt="" /></div>
                </div>
                <?php echo $ssd_section_1; ?>
				<?php echo $ssd_section_2; ?>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    
        <!--- what we can do --->  
    
   <section class="blue-section">
    	<div class="container text-center">
			<?php echo $ssd_section_4; ?>
        </div>
    </section> 

<?php get_footer(); ?>