<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include
$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
	yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
                <div class="row">
                    <div class="col-sm-6">
                        <h2>Depakote</h2>
                        <div class="box-gray">
                            <h4>Abboutt Labs Settles Depakote Marketing Charges with Justice Department</h4>
                            <a href="/wp-content/uploads/2016/06/DEPAKOTE-SETTLE.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <h2>Mesh</h2>
                        <div class="box-gray">
                            <h4>J&J Ordered to Pay $5.7 Million Over Incontinence Implant</h4>
                        	<a href="/wp-content/uploads/2016/06/MESH-SETTLE-1.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <div class="box-gray">
                            <h4>BREAKING: J&J Found Liable In 1st Philly Pelvic Mesh Case</h4>
                        	<a href="/wp-content/uploads/2016/06/MESH-SETTLE-2.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <div class="box-gray">
                            <h4>J&J Ordered to Pay $5.7 Million Over Incontinence Implant, AMS Settles for $1.6 Billion</h4>
                        	<a href="/wp-content/uploads/2016/06/MESH-SETTLE-3.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <div class="box-gray">
                            <h4>J&J to Pay $120 Million in Its First Big Mesh Settlement</h4>
                        	<a href="/wp-content/uploads/2016/06/MESH-SETTLE-4.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <h2>Hip</h2>
                        <div class="box-gray">
                            <h4>Stryker Corp to pay at least $1.4 billion to settle hip replacement lawsuits</h4>
                        	<a href="/wp-content/uploads/2016/06/HIP-SETTLE-1.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <h2>Pradaxa</h2>
                        <div class="box-gray">
                            <h4>$650 Million to Settle Blood Thinner Lawsuits</h4>
                        	<a href="/wp-content/uploads/2016/06/PRADAXA-SETTLE.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <h2>Risperdal</h2>
                        <div class="box-gray">
                            <h4>J&J Hit With $70 Million Risperdal Verdict Over Male Breasts</h4>
                        	<a href="/wp-content/uploads/2016/07/JJ-Hit-With-70-Million-Risperdal-Verdict-Over-Male-Breasts.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <h2>Talc</h2>
                        <div class="box-gray">
                            <h4>J&J must pay $72 million for cancer death linked to talcum powder: lawyers</h4>
                        	<a href="/wp-content/uploads/2016/06/TALC-SETTLE-1.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                        <div class="box-gray">
                            <h4>St. Louis jury awards $55 million in talcum powder lawsuit</h4>
                        	<a href="/wp-content/uploads/2016/06/TALC-SETTLE-2.pdf" target="_blank"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/download-btn.png" alt="" /></a>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->

<?php get_footer(); ?>