<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
            	<div class="row">
					<?php while ( have_posts() ) : the_post(); ?>
                    <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <div class="page-content">
                            <?php
                            the_content();
                            wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                            ?>
                        
                                       
                            <div class="col-md-6">  
                            <h2>Conditions / Disabilities</h2>                             
                            	<a href="/mesothelioma-lawsuits/" class="btn btn-blue">Mesothelioma</a><br>                         
                            	<a href="/social-security-disability-lawsuits/" class="btn btn-blue">Social Security Disability</a><br>
                            	<a href="/talcum-powder-ovarian-cancer/" class="btn btn-blue">Talc & Ovarian Cancer</a>
                            </div>
                                       
                            <div class="col-md-6">
                            <h2>Injuries</h2>
                            	<a href="/asbestos-lawsuits/" class="btn btn-blue">Asbestos</a><br>
                            	<a href="/semi-truck-accident-lawsuits/" class="btn btn-blue">Big Rig Trucking</a>
                        
                            </div>
                            
                      
                            
                              
                        </div><!-- /.page-content -->
                    </article><!-- /#page-<?php the_ID(); ?> -->
                    <?php endwhile; ?>
                </div>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->

<?php get_footer(); ?>