<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$our_process = get_field( 'our_process' );
$our_process_column_1 = get_field( 'our_process_column_1' );
$our_process_column_2 = get_field( 'our_process_column_2' );
$our_process_column_3 = get_field( 'our_process_column_3' );
$our_process_column_4 = get_field( 'our_process_column_4' );
$howitworks_case_review = get_field( 'howitworks_case_review' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    
    <section class="blue-section">
    	<div class="container">
        	<?php echo $our_process; ?>
        	<div class="col-sm-3"><?php echo $our_process_column_1; ?></div>
        	<div class="col-sm-3"><?php echo $our_process_column_2; ?></div>
        	<div class="col-sm-3"><?php echo $our_process_column_3; ?></div>
        	<div class="col-sm-3"><?php echo $our_process_column_4; ?></div>
        </div>
    </section>
    
        <!--- free case review callout --->  
    
   <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $howitworks_case_review; ?>
            <a class="btn btn-ghost-light" href="/contact/">Review My Case</a>
        </div>
    </section> 

<?php get_footer(); ?>