<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$top_box = get_field( 'top_box' );$our_process = get_field( 'our_process' );
$our_process_column_1 = get_field( 'our_process_column_1' );
$our_process_column_2 = get_field( 'our_process_column_2' );
$our_process_column_3 = get_field( 'our_process_column_3' );
$our_process_column_4 = get_field( 'our_process_column_4' );
$howitworks_case_review = get_field( 'howitworks_case_review' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<div class="col-sm-8">
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
            </div>
        	<div class="col-sm-4">
            	<div class="home-evaluation-form">
                    <a href="tel:+18004505500" target="_blank">
                        <div class="home-free-consultation">
                            <img src="https://www.helpingtheinjured.com/wp-content/themes/eztheme-child/images/free-consultation.png" alt="">
                            <h3>Free Consultation<br><span class="big"><span class="phonenumber">1-800-450-5500</span></span></h3>
                        </div>
                    </a>
                </div>
                <fieldset>
                    <legend align="center"><a href="/drugs/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/map-marker.png" width="31" height="48" alt="" /></a></legend>
                    <h3><a href="/drugs/">Address</a></h3>
                    4155 Blackhawk Plaza Circle #110<br />Danville CA 94506
                </fieldset>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->

<?php get_footer(); ?>