<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$drugs_case_review = get_field( 'drugs_case_review' );
$drugs_list_1 = get_field( 'drugs_list_1' );
$drugs_list_2 = get_field( 'drugs_list_2' );
$drugs_list_3 = get_field( 'drugs_list_3' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
                <section class="blue-section text-center">
                    <div class="col-sm-6">
                    <h2>Drugs</h2>
                    <ul>
                    <li><a href="https://www.drugs.com/answers/support-group/taxotere/questions/" target="_blank">Taxotere</a></li>
                    <li><a href="https://www.drugs.com/answers/support-group/jardiance/" target="_blank">Jardiance</a></li>
                    <li><a href="https://www.drugs.com/answers/support-group/glyxambi/" target="_blank">Glyxambi</a></li>
                    <li><a href="https://www.drugs.com/answers/support-group/synjardy/" target="_blank">Synjardy</a></li>
                    <li><a href="https://www.dailystrength.org/group/diabetes-type-2/discussion/onglyza" target="_blank">Onglyza</a></li>
                    <li><a href="https://www.drugs.com/answers/support-group/nexium/" target="_blank">Nexium</a></li>
                    <li><a href="https://www.drugs.com/answers/support-group/zofran/" target="_blank">Zofran</a></li>
                    </ul>
                    <h2>Injuries / Conditions</h2>
                    <ul>
                    <li><a href="http://www.asbestosnetwork.com/Tools-And-Resources/Support-Groups.shtml" target="_blank">Asbestos</a></li>
                    <li><a href="http://www.mdjunction.com/social-security-disability-advice" target="_blank">Social Security Disability</a></li>
                    <li><a href="https://www.facebook.com/talcumpowderovariancancergroup" target="_blank">Talc & Ovarian Cancer</a></li>
                    </ul>
                    
                    </div>
                    <div class="col-sm-6">
					 <h2>Medical Devices</h2>
                    <ul>
                    <li><a href="http://www.jenslist.org" target="_blank">Transvaginal Mesh</a></li>
                    <li><a href="http://disc.yourwebapps.com/Indices/8340.html" target="_blank">Hip Implants</a></li>
                    <li><a href="https://www.facebook.com/depuyhipimplantsupportgroup" target="_blank">Depuy</a></li>
                    <li><a href="https://www.facebook.com/StrykerHipRecallSupportGroup" target="_blank">Stryker</a></li>
                    </ul>
                    </div>
                    <div class="clearfix"></div>
                </section> 
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
            
            
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    <!--- list of drugs --->  
    
        <!--- free case review callout --->  
    
   <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $drugs_case_review; ?>
            <a class="btn btn-ghost-light" href="/contact/">Get a FREE Case Review!</a>
        </div>
    </section>  
        

<?php get_footer(); ?>