<?php
/**
 * Blog Index
 *
 * @decription Contains the loop for the blog index page.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include
$has_sidebar = is_active_sidebar( 'sidebar-blog' );
get_header(); ?>
    <main class="site-content">
        <div class="container">
        	<h1 class="text-center">Blog</h1>
        	<?php echo $has_sidebar ? '<div class="col-sm-8 col-lg-9">' : ''; ?>
			<?php while ( have_posts() ) : the_post(); ?>
            <a href="<?php the_permalink(); ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
               	 	<?php if ( has_post_thumbnail() ) { ?>
                    <div class="col-sm-4 post-thumbnail"><?php the_post_thumbnail(); ?></div><!-- /.post-thumbnail -->
                    <div class="col-sm-8">
                    	<h2 class="post-title"><?php the_title(); ?></h2>
                    	<div class="post-excerpt"><?php the_excerpt(); ?></div><!-- /.post-excerpt -->
                    </div>
                    <?php } else { ?>
                    <h2 class="post-title"><?php the_title(); ?></h2>
                    <div class="post-excerpt"><?php the_excerpt(); ?></div><!-- /.post-excerpt -->
                    <div class="post-meta"><small><?php the_time('F jS, Y'); ?> by <?php the_author_posts_link(); ?>&nbsp; |&nbsp; <?php _e( 'Posted in' ); ?> <?php the_category( ', ' ); ?></small></div>
                    <?php }
                    wp_link_pages( array(
                        'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'eztheme' ) . '</span>',
                        'after' => '</div>',
                        'link_before' => '<span>',
                        'link_after' => '</span>'
                    ) );
                    ?>
                </article><!-- /#post-<?php the_ID(); ?> -->
            </a>
            <?php endwhile;
			if ( $has_sidebar ) { ?>
            </div><!-- /.col-sm-8 -->
            <div class="col-sm-4 col-lg-3 blog-sidebar"><?php get_sidebar( 'sidebar-blog' ); ?></div><!-- /.blog-sidebar -->
            <?php } ?>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
<?php get_footer(); ?>