<?php
/**
 * Header
 *
 * @decription Contains the Doctype, 
 * @author Stephen Sabatini
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

// Detect Internet Explorer, Windows Phone, and Edge
$ie = preg_match( '/(MSIE|Windows\sPhone|Edge)/i', $_SERVER['USER_AGENT'] );

// Define Theme Directory
$template_directory_uri = get_template_directory_uri();

// Define theme mods from the theme's customise options.
$logo  = get_theme_mod( 'eztheme_logo' );
$phone = get_theme_mod( 'eztheme_phone' );
$email = get_theme_mod( 'eztheme_email' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
		<?php if ( $ie ) { ?><meta http-equiv="X-UA-Compatible" content="IE=Edge" /><?php } ?>
        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <?php wp_head();
		if ( $ie ) { ?>
		<!--[if lt IE 9]><?php
		  ?><script src="<?php echo $template_directory_uri; ?>/js/html5shiv.min.js"></script><?php
		  ?><script src="<?php echo $template_directory_uri; ?>/js/respond.min.js"></script><?php
		?><![endif]-->
		<?php } ?>

        
        <!-- What Converts -->
        <script src="//scripts.iconnode.com/61080.js"></script>
        
        <!-- Facebook Pixel Code -->
<script>
!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
document,'script','https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '815365568598428');
fbq('track', "PageView");
fbq('track', 'Lead');
fbq('track', 'ViewContent');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=815365568598428&ev=PageView&noscrip
t=1"
/></noscript>
<!-- End Facebook Pixel Code -->
        
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-37779350-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-37779350-1');
</script>

    </head>
    <body <?php body_class(); ?>>
        <div class="site-wrapper">
            <header class="site-header">
                <nav class="navbar navbar-default">
                    <div class="section-top">
                        <div class="container">
                        	<div class="row">
                                <div class="navbar-header col-sm-4 col-md-3 col-lg-3">
                                    <a class="navbar-brand" href="<?php echo home_url(); ?>" rel="home">
                                        <?php if ( isset( $logo ) && $logo !== '' ) { ?>
                                        <img class="site-logo" src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                                        <?php } else { ?>
                                        <div class="site-title"><?php bloginfo( 'name' ); ?></div>
                                        <?php } ?>
                                    </a>
                                </div><!-- /.navbar-header -->
                                <div class="site-meta col-sm-8 col-md-9 col-lg-9">
                                	<div class="row">
                                        <div class="col-md-6"></div>
                                        <div class="col-md-3"><?php echo get_search_form(); ?></div>
                                        <div class="col-md-3">
                                        <?php if ( $phone !== false ) { ?>
                                       <div class="site-tel"><a href="tel:<?php echo preg_replace( "/[^0-9]/", "", $phone ); ?>" target="_blank"><span class="phonenumber"><?php echo $phone; ?></span></a></div>
                                        <?php
                                        } if ( $email !== false ) { ?>
                                        <div class="site-email"><a href="mailto:<?php echo $email; ?>" target="_blank"><?php echo $email; ?></a></div>
                                        <?php } ?>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="site-navigation">
                                        <?php
                                        wp_nav_menu( array(
                                            'menu'              => 'menu-header',
                                            'theme_location'    => 'menu-header',
                                            'depth'             => 3,
                                            'container'         => 'div',
                                            'container_id'      => 'menu-header'
                                        ) );
                                        ?>
                                    </div><!-- /.site-navigation -->
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div><!-- /.container -->
                    </div><!-- /.section-top -->
                </nav><!-- /.navbar.navbar-default -->
            </header><!-- /.site-header -->
