<?php
/**
 * Function Definitions
 *
 * @decription Contains the functions for the WordPress theme.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include


// This function include the parent theme and child theme CSS.
function child_theme_enqueue_styles() {
	wp_enqueue_style( 'eztheme', get_template_directory_uri() . '/style.css', array( 'bootstrap' ) );
	wp_enqueue_style( 'eztheme-child', get_stylesheet_directory_uri() . '/style.css', array( 'bootstrap', 'eztheme' ) );
}
add_action( 'wp_enqueue_scripts', 'child_theme_enqueue_styles' );
add_filter( 'gform_enable_field_label_visibility_settings', '__return_true' );


// Deregister Slicknav
wp_dequeue_style( 'slicknav' );
wp_dequeue_script( 'slicknav-script' );


// Register Custom Menus that are used in the theme.
function child_theme_menus_init() {
	register_nav_menus( array(
		'menu-footer-1' => __( 'Footer: Main Links', 'eztheme' ),
		'menu-footer-2' => __( 'Footer: Find Information About', 'eztheme' )
	) );
}
add_action( 'init', 'child_theme_menus_init' );


// Register Custom Sidebars/Widgets that are used in the theme.
function child_theme_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Page Sidebar', 'eztheme' ),
		'id' => 'sidebar-page',
		'description' => __( 'Widgets in this area will be shown on the pages\' sidebar.', 'eztheme' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widgettitle">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'child_theme_widgets_init' );
?>
