<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$home_bills_of_rights = get_field( 'home_bills_of_rights' );
$home_about_us = get_field( 'home_about_us' );
$home_how_we_take_care_of_you_top = get_field( 'home_how_we_take_care_of_you_top' );
$home_how_we_take_care_of_you_column_1 = get_field( 'home_how_we_take_care_of_you_column_1' );
$home_how_we_take_care_of_you_column_2 = get_field( 'home_how_we_take_care_of_you_column_2' );
$home_how_we_take_care_of_you_column_3 = get_field( 'home_how_we_take_care_of_you_column_3' );
$home_how_we_take_care_of_you_column_4 = get_field( 'home_how_we_take_care_of_you_column_4' );
$home_case_review = get_field( 'home_case_review' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );

get_header();
?>
	<div class="home-banner text-center">
        <h2>WE ARE COMMITTED TO GETTING YOU <br class="hidden-xs" />THE <span>HELP YOU DESERVE!</span></h2>
        <a class="btn btn-primary" href="/contact/">GET YOUR FREE CASE REVIEW</a>
        <div class="home-banner-callouts">
        	<div class="container">
            	<div class="col-sm-4">
                	<fieldset>
                    	<legend align="center"><a href="/drugs/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/callout-1.png" alt="" /></a></legend>
                        <h3><a href="/drugs/">Drug Lawsuits</a></h3>
                        <a class="btn btn-link" href="/drugs/">Learn More Today</a>
                    </fieldset>
                </div>
            	<div class="col-sm-4">
                	<fieldset>
                    	<legend align="center"><a href="/medical-devices/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/callout-2.png" alt="" /></a></legend>
                        <h3><a href="/medical-devices/">Medical Device Recalls</a></h3>
                        <a class="btn btn-link" href="/medical-devices/">Get Answers Now</a>
                    </fieldset>
                </div>
            	<div class="col-sm-4">
                	<fieldset>
                    	<legend align="center"><a href="/injuries-conditions/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/callout-3.png" alt="" /></a></legend>
                        <h3><a href="/injuries-conditions/">Injuries</a></h3>
                        <a class="btn btn-link" href="/injuries-conditions/">Learn More Today</a>
                    </fieldset>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
	</div>
    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ezsolution' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
                <div class="panel panel-default">
                    <div class="panel-body">
                    	<h3>WE HELP PEOPLE WHO WERE INJURED BY DANGEROUS DRUGS AND MEDICAL DEVICES</h3>
						<?php echo get_search_form(); ?>
                    </div>
                </div>
                <table style="width: 100%;">
                	<tr>
                    	<td style="width: 33%;"><div style="border:1px solid #000; width: 100%;"></div></td>
                    	<td><h2 style="text-align: center;">BILL OF RIGHTS</h2></td>
                    	<td style="width: 33%;"><div style="border:1px solid #000; width: 100%;"></div></td>
                    </tr>
                </table>
                <?php echo $home_bills_of_rights; ?>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    <section class="home-about">
    	<div class="container">
        	<div class="col-sm-3"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo-white.png" alt="" /></div>
        	<div class="col-sm-9">
				<?php echo $home_about_us; ?>
            	<a class="btn btn-ghost-light" href="/about/">Learn More About Us</a>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>
    <section class="home-how-we-work">
    	<div class="container">
        	<?php echo $home_how_we_take_care_of_you_top; ?>
        	<div class="col-sm-3"><?php echo $home_how_we_take_care_of_you_column_1; ?></div>
        	<div class="col-sm-3"><?php echo $home_how_we_take_care_of_you_column_2; ?></div>
        	<div class="col-sm-3"><?php echo $home_how_we_take_care_of_you_column_3; ?></div>
        	<div class="col-sm-3"><?php echo $home_how_we_take_care_of_you_column_4; ?></div>
        </div>
    </section>
    <section class="home-review-case">
    	<div class="container text-center">
			<?php echo $home_case_review; ?>
            <a class="btn btn-ghost-light" href="/contact/">Review My Case</a>
        </div>
    </section>
<?php get_footer(); ?>