<?php
/**
 * Site Footer
 *
 * @decription Contains the site footer as well as the closing tags for the site wrapper, body, and html tags.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include


// Define theme mods from the theme's customise options.
$copyright = get_theme_mod( 'eztheme_copyright' );
$logo      = get_theme_mod( 'eztheme_logo' );
$phone     = get_theme_mod( 'eztheme_phone' );
$email     = get_theme_mod( 'eztheme_email' );
?>
            <footer class="site-footer">
                <div class="container">
                	<div class="col-sm-3">
                    	<a href="<?php echo home_url(); ?>" rel="home">
							<?php if ( isset( $logo ) && $logo !== '' ) { ?>
                            <img class="site-logo" src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                            <?php } else { ?>
                            <div class="site-title"><?php bloginfo( 'name' ); ?></div>
                            <?php } ?>
                        </a>
                    </div>
                	<div class="col-sm-3">
                    	<div class="col-xs-2"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/call-us.png" alt="" /></div>
                    	<div class="col-xs-10">
                            <h4>Call Us Anytime</h4>
                            <div class="big"><span class="phonenumber">1-800-450-5500</span></div>
                        </div>
                        <div class="clearfix"></div>
                    
                    </div>
                	<div class="col-sm-3">
                    	<h4>Main Links</h4>
						<?php
                        wp_nav_menu( array(
                            'menu'              => 'menu-footer-1',
                            'theme_location'    => 'menu-footer-1',
                            'depth'             => 1,
                            'container'         => 'div',
                            'container_id'      => 'menu-footer-1'
                        ) );
                        ?>
                    </div>
                	<div class="col-sm-3">
                    	<h4>Find Information About</h4>
						<?php
                        wp_nav_menu( array(
                            'menu'              => 'menu-footer-2',
                            'theme_location'    => 'menu-footer-2',
                            'depth'             => 1,
                            'container'         => 'div',
                            'container_id'      => 'menu-footer-2'
                        ) );
                        ?>
                    </div>
                </div><!-- /.container -->
                <div class="site-copyright">
                	<div class="container">
                	<?php
                    if ( isset( $copyright ) && $copyright != '' ) {
						echo '&copy; ' . date( 'Y' ) . ' ' . $copyright;
                    }
                    ?>
                    
                    
                    </div>
                </div>
            </footer><!-- /.site-footer -->
        </div><!-- /.site-wrapper -->
        <?php wp_footer(); ?>

<!-- Google Code for Remarketing Tag -->
<!--------------------------------------------------
Remarketing tags may not be associated with personally identifiable information or placed on pages related to sensitive categories. See more information and instructions on how to setup the tag on: http://google.com/ads/remarketingsetup
--------------------------------------------------->
<script type="text/javascript">
/* <![CDATA[ */
var google_conversion_id = 881592135;
var google_custom_params = window.google_tag_params;
var google_remarketing_only = true;
/* ]]> */
</script>


    </body>
</html>