<?php
/**
 * Page
 *
 * @decription Contains the loop for the page template.
 * @author EZSolution Corp.
 * @since EZTheme 1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) or exit; // Prevent direct access to include

$ovarian_section_1 = get_field( 'ovarian_section_1' );
$ovarian_section_2 = get_field( 'ovarian_section_2' );
$ovarian_section_3 = get_field( 'ovarian_section_3' );
$ovarian_section_4 = get_field( 'ovarian_section_4' );

$has_sidebar = is_active_sidebar( 'sidebar-page' );
get_header();

if ( function_exists( 'yoast_breadcrumb' ) ) {
 yoast_breadcrumb( '<div class="site-breadcrumbs"><div class="container">', '</div><!-- /.container --></div><!-- /.site-breadcrumbs -->' );
}
?>

    <main class="site-content">
        <div class="container">
        	<?php echo $has_sidebar ? '<div class="col-md-8">' : ''; ?>
				<?php while ( have_posts() ) : the_post(); ?>
                <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="page-content">
                        <?php
                        the_content();
                        wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'eztheme' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                        ?>
                    </div><!-- /.page-content -->
                </article><!-- /#page-<?php the_ID(); ?> -->
                <?php endwhile; ?>
            </div>
			<?php
            if ( $has_sidebar ) {
				?><aside class="col-md-4"><?php dynamic_sidebar( 'sidebar-page' ); ?></aside><?php
			}
			?>
            <div class="clearfix"></div>
            <div class="col-sm-3">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/cancer1.jpg" alt="" />
                </div>
            <div class="col-sm-9"><?php echo $ovarian_section_1; ?></div>
             <div class="col-sm-3">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/cancer2.jpg" alt="" />
                </div>
            <div class="col-sm-9"><?php echo $ovarian_section_2; ?></div>
             <div class="col-sm-3">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/cancer3.jpg" alt="" />
             </div>
            <div class="col-sm-9"><?php echo $ovarian_section_3; ?></div>
            <div class="clearfix"></div>
        </div><!-- /.container -->
    </main><!-- /.site-content -->
    
    
        <!--- what we can do --->  
    
   <section class="blue-section">
    	<div class="container text-center">
			<?php echo $ovarian_section_4; ?>
            <a class="btn btn-ghost-light" href="/contact/">Review My Case</a>
        </div>
    </section> 

<?php get_footer(); ?>